/*
 * @(#)SimulationListener.java  1.1  2006-09-27
 *
 * Copyright (c) 2003 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */


package ch.hslu.cm.simulation;

/**
 * SimulationListener.
 *
 * @author  Werner Randelshofer
 * @version 1.1 2006-09-27 Renamed elementAdded,elementRemoved to objectAdded,
 * objectRemoved.
 * <br>1.0 2. Dezember 2003  Created.
 */
public interface SimulationListener extends java.util.EventListener {
    
    /**
     * Sent when an object was added to the simulation.
     */
    public void objectAdded(SimulationEvent e);
    /**
     * Sent when an object was removed from the simulation.
     */
    public void objectRemoved(SimulationEvent e);
}
